<?php
require_once __DIR__ . '/config/config.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['test_mode'])) {
        updateSetting('otp_test_mode', $_POST['test_mode']);
        $message = 'تنظیمات ذخیره شد';
    }
    
    if (isset($_POST['api_key'])) {
        updateSetting('ippanel_api_key', $_POST['api_key']);
        updateSetting('ippanel_pattern_code', $_POST['pattern_code']);
        updateSetting('ippanel_sender', $_POST['sender']);
        $message = 'تنظیمات API ذخیره شد';
    }
}

$testMode = getSetting('otp_test_mode', '0');
$apiKey = getSetting('ippanel_api_key', '');
$patternCode = getSetting('ippanel_pattern_code', '');
$sender = getSetting('ippanel_sender', '');
?>

<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تنظیمات OTP</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Vazirmatn', Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 40px 20px;
        }
        
        .container {
            max-width: 800px;
            margin: 0 auto;
        }
        
        .card {
            background: white;
            border-radius: 20px;
            padding: 40px;
            margin-bottom: 30px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
        }
        
        h1 {
            color: #1e293b;
            font-size: 2rem;
            font-weight: 800;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        h1 i {
            color: #667eea;
        }
        
        h2 {
            color: #1e293b;
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 2px solid #e2e8f0;
        }
        
        .alert {
            padding: 15px 20px;
            border-radius: 12px;
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            gap: 12px;
            font-weight: 600;
        }
        
        .alert-success {
            background: #d1fae5;
            color: #065f46;
            border: 2px solid #6ee7b7;
        }
        
        .alert-warning {
            background: #fef3c7;
            color: #92400e;
            border: 2px solid #fcd34d;
        }
        
        .form-group {
            margin-bottom: 25px;
        }
        
        .form-group label {
            display: block;
            font-weight: 700;
            color: #334155;
            margin-bottom: 10px;
            font-size: 1.05rem;
        }
        
        .form-group input,
        .form-group select {
            width: 100%;
            padding: 14px;
            border: 2px solid #e2e8f0;
            border-radius: 10px;
            font-size: 1rem;
            font-family: 'Vazirmatn', Tahoma, Arial, sans-serif;
            transition: all 0.3s ease;
        }
        
        .form-group input:focus,
        .form-group select:focus {
            outline: none;
            border-color: #667eea;
            box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
        }
        
        .form-group small {
            display: block;
            margin-top: 8px;
            color: #64748b;
            font-size: 0.9rem;
        }
        
        .toggle-switch {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 15px;
            background: #f8fafc;
            border-radius: 10px;
        }
        
        .toggle-switch input[type="checkbox"] {
            width: 60px;
            height: 30px;
            appearance: none;
            background: #cbd5e1;
            border-radius: 15px;
            position: relative;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .toggle-switch input[type="checkbox"]:checked {
            background: #10b981;
        }
        
        .toggle-switch input[type="checkbox"]::before {
            content: '';
            position: absolute;
            width: 26px;
            height: 26px;
            border-radius: 50%;
            background: white;
            top: 2px;
            right: 2px;
            transition: all 0.3s;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
        }
        
        .toggle-switch input[type="checkbox"]:checked::before {
            right: 32px;
        }
        
        .toggle-label {
            flex: 1;
        }
        
        .toggle-label strong {
            display: block;
            color: #1e293b;
            font-size: 1.1rem;
            margin-bottom: 5px;
        }
        
        .toggle-label span {
            color: #64748b;
            font-size: 0.95rem;
        }
        
        .btn {
            padding: 14px 30px;
            border: none;
            border-radius: 10px;
            font-size: 1.05rem;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 10px;
            font-family: 'Vazirmatn', Tahoma, Arial, sans-serif;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        
        .btn-success {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
        }
        
        .btn-success:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(16, 185, 129, 0.4);
        }
        
        .info-box {
            background: #e0e7ff;
            padding: 20px;
            border-radius: 12px;
            margin-top: 20px;
        }
        
        .info-box h3 {
            color: #3730a3;
            font-size: 1.1rem;
            margin-bottom: 10px;
        }
        
        .info-box p {
            color: #4c1d95;
            line-height: 1.8;
        }
        
        .back-link {
            display: inline-flex;
            align-items: center;
            gap: 8px;
            color: white;
            text-decoration: none;
            font-weight: 700;
            margin-bottom: 20px;
            transition: all 0.3s;
        }
        
        .back-link:hover {
            transform: translateX(5px);
        }
    </style>
</head>
<body>
    <div class="container">
        <a href="/" class="back-link">
            <i class="fas fa-arrow-right"></i>
            بازگشت به صفحه اصلی
        </a>
        
        <div class="card">
            <h1>
                <i class="fas fa-cog"></i>
                تنظیمات OTP
            </h1>
            
            <?php if (isset($message)): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i>
                    <?php echo $message; ?>
                </div>
            <?php endif; ?>
            
            <!-- Test Mode -->
            <form method="POST">
                <h2>حالت تست</h2>
                
                <div class="form-group">
                    <div class="toggle-switch">
                        <input type="checkbox" 
                               id="test_mode" 
                               name="test_mode" 
                               value="1" 
                               <?php echo $testMode === '1' ? 'checked' : ''; ?>
                               onchange="this.form.submit()">
                        <div class="toggle-label">
                            <strong>حالت تست (بدون ارسال SMS واقعی)</strong>
                            <span>در حالت تست، SMS ارسال نمی‌شود و فقط در لاگ ثبت می‌شود</span>
                        </div>
                    </div>
                </div>
                
                <?php if ($testMode === '1'): ?>
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle"></i>
                        حالت تست فعال است! SMS واقعی ارسال نمی‌شود. کد OTP در لاگ PHP ثبت می‌شود.
                    </div>
                <?php endif; ?>
            </form>
            
            <!-- API Settings -->
            <form method="POST">
                <h2>تنظیمات IPPanel API</h2>
                
                <div class="form-group">
                    <label><i class="fas fa-key"></i> API Key</label>
                    <input type="text" name="api_key" value="<?php echo htmlspecialchars($apiKey); ?>" required>
                    <small>API Key دریافتی از پنل IPPanel</small>
                </div>
                
                <div class="form-group">
                    <label><i class="fas fa-code"></i> Pattern Code</label>
                    <input type="text" name="pattern_code" value="<?php echo htmlspecialchars($patternCode); ?>" required>
                    <small>کد الگوی پیامک (Pattern Code)</small>
                </div>
                
                <div class="form-group">
                    <label><i class="fas fa-phone"></i> Sender Number</label>
                    <input type="text" name="sender" value="<?php echo htmlspecialchars($sender); ?>" required>
                    <small>شماره ارسال‌کننده (مثال: +985000125475)</small>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i>
                    ذخیره تنظیمات API
                </button>
            </form>
            
            <div class="info-box">
                <h3><i class="fas fa-info-circle"></i> راهنما</h3>
                <p>
                    <strong>حالت تست:</strong> برای تست سیستم بدون ارسال SMS واقعی، حالت تست را فعال کنید. 
                    کد OTP در فایل لاگ PHP ثبت می‌شود و می‌توانید از آن برای تست استفاده کنید.
                </p>
                <p style="margin-top: 10px;">
                    <strong>مشاهده لاگ:</strong> برای مشاهده کد OTP در حالت تست، فایل error_log سرور خود را بررسی کنید.
                </p>
            </div>
        </div>
        
        <div class="card">
            <h2>تست سریع</h2>
            <p style="margin-bottom: 20px; color: #64748b;">برای تست سیستم OTP از لینک‌های زیر استفاده کنید:</p>
            
            <a href="/test-otp-api.php" class="btn btn-success" style="margin-left: 10px;">
                <i class="fas fa-flask"></i>
                تست API
            </a>
            
            <a href="/login.php" class="btn btn-primary">
                <i class="fas fa-sign-in-alt"></i>
                تست Login
            </a>
        </div>
    </div>
</body>
</html>

